unit UMComboBoxMce;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type

MComboBoxMce = class(TComboBox)
private
	procedure   Wypelnij_i_ustaw_cb();
	procedure   MyOnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
	procedure   MyOnKeyPress(Sender: TObject; var Key: Char);

public
	procedure   CreateWnd(); override;
	procedure   DestroyWnd(); override;
	constructor Create(AOwner: TComponent);
end;

implementation
{------------------------------------------------------------------------------}
constructor MComboBoxMce.Create(AOwner: TComponent);
begin
	inherited Create(AOwner);

   OnKeyDown  := MyOnKeyDown;
   OnKeyPress := MyOnKeyPress;
end;

procedure MComboBoxMce.CreateWnd();
begin
	inherited;
	Wypelnij_i_ustaw_cb();
end;

procedure MComboBoxMce.DestroyWnd();
begin
   // wyczy ComboBox.Items
   Clear();

	inherited;
end;

procedure MComboBoxMce.Wypelnij_i_ustaw_cb();
var
   Year, Month, Day : Word;

   mc         : Integer;
   dzisiaj    : TDate;
   poz        : Integer;
   seekmc     : Integer;
   txt        : String;

begin
   mc      := 0;
   dzisiaj := Date();
   poz     := 0;
   seekmc  := 0;
   txt     := '';

   Clear();
   Width := 45;

   for mc := 1 to 12 do
   begin
      Items.Add(IntToStr(mc));
   end;

   dzisiaj := Date();
   DecodeDate(dzisiaj, Year, Month, Day);
   seekmc  := Month;
   txt     := IntToStr(seekmc);

	ItemIndex := -1;
   poz := Items.IndexOf(txt);
   if poz > -1 then
   begin
      ItemIndex := poz;
   end;
end;

procedure MComboBoxMce.MyOnKeyDown(Sender: TObject; var Key: Word; Shift: TShiftState);
begin
   if (Key = VK_DOWN) or (Key = VK_UP) then
   begin
		// OK
   end
   else begin
      Key := 0;
   end;
end;

procedure MComboBoxMce.MyOnKeyPress(Sender: TObject; var Key: Char);
begin
   if (Key = CHR(VK_DOWN)) or (Key = CHR(VK_UP)) then
   begin
      // OK
   end
   else begin
      Key := CHR(0);
   end;
end;

end.

